package jp.kawakubo;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;

public class JPAUpdateStandalone {
    public static void main(String[] args) {
        // Entityマネージャファクトリを生成する
        EntityManagerFactory entityManagerFactory
                = Persistence.createEntityManagerFactory("JPASample01PU");
        // Entityマネージャを生成する
        EntityManager entityManager = entityManagerFactory.createEntityManager();

        // Entityトランザクションを取得し、トランザクションを開始する
        EntityTransaction entityTransaction = entityManager.getTransaction();
        entityTransaction.begin();
        // beginとcommitの間にCRUD操作を記述する
        // findメソッドでmeigaraテーブルよりMeigaraオブジェクトを取得する
        // 第2引数はIdアノテーションで指定したカラムの値
        Meigara meigara = entityManager.find(Meigara.class, 9);
        meigara.setVolume(0.9f);
        meigara.setPrice(1050);
        // トランザクションをコミットする
        entityTransaction.commit();
        // Entityマネージャをクローズする
        entityManager.close();

    }
}
